/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.GuiPopupTools;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbuilder.RFToolsBuilder;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControllerTileEntity;
import mcjty.rftoolsbuilder.modules.mover.client.SyncedList;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.apache.commons.lang3.tuple.Pair;

public class GuiMoverController
extends GenericGuiContainer<MoverControllerTileEntity, GenericContainer> {
    private EnergyBar energyBar;
    private SyncedList<String> vehicleList;
    private SyncedList<Pair<BlockPos, String>> nodeList;

    public GuiMoverController(MoverControllerTileEntity builderTileEntity, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)builderTileEntity, (AbstractContainerMenu)container, inventory, ((BaseBlock)MoverModule.MOVER_CONTROLLER.get()).getManualEntry());
    }

    public static void register() {
        GuiMoverController.register((MenuType)((MenuType)MoverModule.CONTAINER_MOVER_CONTROLLER.get()), GuiMoverController::new);
    }

    public void m_7856_() {
        this.window = new Window((Screen)this, this.tileEntity, RFToolsBuilderMessages.INSTANCE, new ResourceLocation("rftoolsbuilder", "gui/mover_controller.gui"));
        super.m_7856_();
        this.initializeFields();
        this.setupEvents();
        this.vehicleList.refresh();
        this.nodeList.refresh();
    }

    private void setupEvents() {
        ((Button)this.window.findChild("scan")).event(this::doScan);
        ((Button)this.window.findChild("move")).event(this::doMove);
        this.nodeList.getList().event(new SelectionEvent(){

            public void select(int index) {
            }

            public void doubleClick(int index) {
                GuiMoverController.this.selectNode();
            }
        });
    }

    private void doMove() {
        if (this.nodeList.getSelected() == null) {
            GuiPopupTools.showMessage((Minecraft)this.f_96541_, (Screen)this, (WindowManager)this.getWindowManager(), (int)100, (int)100, (String)"Please select a node!");
            return;
        }
        if (this.vehicleList.getSelected() == null) {
            GuiPopupTools.showMessage((Minecraft)this.f_96541_, (Screen)this, (WindowManager)this.getWindowManager(), (int)100, (int)100, (String)"Please select a vehicle!");
            return;
        }
        this.sendServerCommandTyped(RFToolsBuilderMessages.INSTANCE, MoverControllerTileEntity.CMD_MOVE, TypedMap.builder().put(MoverControllerTileEntity.SELECTED_NODE, (Object)((BlockPos)this.nodeList.getSelected().getLeft())).put(MoverControllerTileEntity.SELECTED_VEHICLE, (Object)this.vehicleList.getSelected()).put(MoverControllerTileEntity.SELECTED_DESTINATION, (Object)((String)this.nodeList.getSelected().getRight())).build());
        this.vehicleList.refresh();
        this.nodeList.refresh();
    }

    private void doScan() {
        this.sendServerCommandTyped(RFToolsBuilderMessages.INSTANCE, MoverControllerTileEntity.CMD_SCAN, TypedMap.EMPTY);
        this.vehicleList.refresh();
        this.nodeList.refresh();
    }

    private void selectNode() {
        Pair<BlockPos, String> selected = this.nodeList.getSelected();
        if (selected != null) {
            this.sendServerCommandTyped(RFToolsBuilderMessages.INSTANCE, MoverControllerTileEntity.CMD_SELECTNODE, TypedMap.builder().put(MoverControllerTileEntity.SELECTED_NODE, (Object)((BlockPos)selected.getLeft())).build());
        }
    }

    private void initializeFields() {
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.vehicleList = new SyncedList<String>((WidgetList)this.window.findChild("vehicles"), this::requestVehicles, this::makeVehicleLine, 10);
        this.nodeList = new SyncedList<Pair>((WidgetList)this.window.findChild("nodes"), this::requestNodes, this::makeNodeLine, 20);
        this.updateFields();
    }

    private void updateFields() {
        this.updateEnergyBar(this.energyBar);
        this.vehicleList.populateLists();
        this.nodeList.populateLists();
    }

    public static void setVehiclesFromServer(List<String> vehicles) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof GuiMoverController) {
            GuiMoverController gui = (GuiMoverController)screen;
            gui.vehicleList.setFromServerList(vehicles);
        } else {
            RFToolsBuilder.setup.getLogger().warn("This is not a gui for the mover controller!");
        }
    }

    public static void setNodesFromServer(List<Pair<BlockPos, String>> nodes) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof GuiMoverController) {
            GuiMoverController gui = (GuiMoverController)screen;
            gui.nodeList.setFromServerList(nodes);
        } else {
            RFToolsBuilder.setup.getLogger().warn("This is not a gui for the mover controller!");
        }
    }

    public static void setSelectedVehicle(String vehicle) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof GuiMoverController) {
            GuiMoverController gui = (GuiMoverController)screen;
            gui.vehicleList.select(vehicle);
        } else {
            RFToolsBuilder.setup.getLogger().warn("This is not a gui for the mover controller!");
        }
    }

    private void requestVehicles() {
        RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketGetListFromServer(((MoverControllerTileEntity)this.tileEntity).m_58899_(), MoverControllerTileEntity.CMD_GETVEHICLES.name()));
    }

    private void requestNodes() {
        RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketGetListFromServer(((MoverControllerTileEntity)this.tileEntity).m_58899_(), MoverControllerTileEntity.CMD_GETNODES.name()));
    }

    private Panel makeVehicleLine(String vehicle) {
        Panel panel = (Panel)Widgets.horizontal((int)0, (int)0).hint(0, 0, 130, 14);
        panel.children(new Widget[]{Widgets.label((String)vehicle)});
        return panel;
    }

    private Panel makeNodeLine(Pair<BlockPos, String> node) {
        Panel panel = (Panel)Widgets.horizontal((int)0, (int)0).hint(0, 0, 100, 14);
        panel.children(new Widget[]{Widgets.label((String)((String)node.getRight()))});
        return panel;
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.updateFields();
        this.drawWindow(matrixStack);
    }
}

